/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

var STBGlobalFormsSelect = Object.create(STBModule.prototype);

STBGlobalFormsSelect.name = "GlobalFormsSelect";
STBGlobalFormsSelect.initOneTime = function() {
	//on change select redirect
	$("select[data-click=true]").on(
		'change', 
		function() {
			window.location.href = $(this).find("option:selected").attr("data-link")
		}
	);
}

STBGlobalFormsSelect.initEveryTime = function() {

		var elements = null;

		//default select on selects
		elements = $("select[data-selected]:not(.__done)");

		if (elements.length){
			elements.each(function () {
				var obj = $(this);
				obj.val(obj.attr("data-selected"));

				if (obj.data("chosen")) {
					obj.chosen.trigger("update");
				}

				obj.addClass("__done");
			});
		}

		//initialise chosen plugin
		elements = $('select:not(.__done)');

		if (elements.length){
			elements.chosen({
	            disable_search_threshold: 10,
				allow_single_deselect: true
	        });

			elements.addClass("__done");
		}
}


STBGlobalFormsSelect.runOnReady = function() {
	STBGlobalFormsSelect.initOneTime();
	STBGlobalFormsSelect.initEveryTime();
}

STBGlobalFormsSelect.runOnContentUpdate = function() {
		STBGlobalFormsSelect.initEveryTime();

}

site.registerModule(STBGlobalFormsSelect);
